﻿{
	// 3D Grid V1.0 (build 1) © Ben Rollason. May 2010	
	
	//FUTURE...
	//place in front of camera.
	
	do3DGrid(this);

	function do3DGrid() {
		
	
		var proj = app.project;
		var undoStr = "Grid 3D";
		var activeItem = proj.activeItem;
		
		var G3D = null;
		var G3D = new Object();
		
		//basics
		G3D.scriptName = "Grid 3D";
		G3D.version = "1.0";
		G3D.scriptTitle = G3D.scriptName + G3D.version;
		
		//UI data
		G3D.scrollSize = "[130,20]";
		(parseFloat(app.version) >= 9.0) ? G3D.eTextSize = "[30,-1]" : G3D.eTextSize = "[30,15]";
		(parseFloat(app.version) >= 9.0) ? G3D.eTextSize2 = "[40,-1]" : G3D.eTextSize2 = "[40,15]";
		G3D.panelSize = "[210,-1]";
		
		//key data
		G3D.sizeX = 500;
		G3D.sizeZ = 500;
		G3D.divisionsX = 20;
		G3D.divisionsZ = 20;
		G3D.placement = [0,0,0];
		G3D.posIndex = 0; //can be 0,1 or 2.... corresponding to bottom of comp, compheight.2 below cam, origin
		
		//buttons
		G3D.strHelp = "?";
		G3D.strButton = "Create";
		G3D.undrCamButton = "XYZ";
		
		//help and alerts
		G3D.help = "";
		G3D.help += "© Ben Rollason 2010.\nvfx.benrollason.com\n\nRun the script to create a floor grid to help you navigate the AE 3D environment - like in a 3D program.\n\n";
		G3D.help += "Choose grid unit size, number of units and placement and click Create.\n\n";
		G3D.help += "Note, that owing to the After Effects coordinate system, placing a floor grid at [0,0,0] will place it above you with its anchor point in the top left corner of the screen.";
		G3D.help += "Therefore, placement defaults to placing the grid's anchor point at the middle bottom of the active camera's view.";
		G3D.help += "By clicking the XYZ button, you can toggle the setting between this, comp.height/2 below the camera and the origin.";
				
		G3D.notEnglish = "As for most scripts, After Effects needs to be running in English for " + G3D.scriptName + " to work.";
		G3D.versionTooOld = "You need to be using After Effects CS3 or above for " + G3D.scriptName + " to work.";
		G3D.noActiveItem = "You must have a composition selected to run " + G3D.scriptName + ".";
		
		if(G3Dpreflight()) {	
				
				if((activeItem) && (activeItem != null) && (activeItem instanceof CompItem)) {
					G3D.placement = G3Dplacement(G3D.posIndex);
				}
				
				G3D.toolsPanel = G3DcreateUI(this);
				G3D.toolsPanel.show();
				
		}
	
		function G3DdegsToRads(degs) {
			return(Math.PI*2*degs/360);
		}
	
		function G3Dplacement(aIndex) {
			
			var tRet;
			activeItem = proj.activeItem;
			
			if(activeItem && activeItem != null) {
				switch (aIndex) 
			
				{
			
					case 0:
						
						// original at middle bottom of default camera's view
						tRet = [activeItem.width/2, activeItem.height, 0];
						break;
						
					case 1:
					
						//origin compheight/2 below the current camera
						
						if(activeItem.activeCamera) {
							G3D.camPos = activeItem.activeCamera.transform.position.value;
							G3D.camPos = [Math.round(G3D.camPos[0]), Math.round(G3D.camPos[1]), Math.round(G3D.camPos[2])];
						} else {
							G3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(G3DdegsToRads(39.6/2)))];
						}
						
						tRet = G3D.camPos + [0, activeItem.height/2, 0]; 
						break;
						
					case 2:
					
						//origin at world origin
						tRet = [0,0,0];
						break;
						
					case 3:
					
						//origin at middle bottom of current camera's view
						//this is work in progress and requires a math version of expression language's toWorld function.
						
						if(activeItem.activeCamera) {
							G3D.camPos = activeItem.activeCamera.transform.position.value;
						} else {
							G3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
						}
						
						tRet = [0,0,0];//tRet = ??
						break;
						
					default:
					
						tRet = [activeItem.width/2, activeItem.height, 0];
						break;
						
					
				}//switch
		
			} else {
				
				tRet = [0,0,0];
				
			} //if(activeItem && activeItem != null) 
		
			return(tRet);
			
			
		}
	
		function G3Dpreflight() {
				
			var isEnglish = ((app.isoLanguage == "en_US") || (app.language == Language.ENGLISH));
			var appVersionTooOld = (parseFloat(app.version) < 8.0)
	
			if(appVersionTooOld) {
				alert(G3D.versionTooOld);
				return(false);
			} else if (!isEnglish) {
				alert(G3D.notEnglish);
				return(false);
			} else {
				return(true);
			}
		
		}
		
	
		function G3DcreateUI(thisObj) {
			
			var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", G3D.scriptName, undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
				
			if (pal != null) {
					
				var res =
					"group { \
						orientation:'column', alignment:['left','top'], \
						Panel1: Panel { text: 'Division Size', orientation: 'column', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								sizeXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								sizeXScroll:Scrollbar { minvalue:100, maxvalue:1000, preferredSize:"+ G3D.scrollSize +", value: " + G3D.sizeX + ", stepdelta:1, jumpdelta:50, alignment:['fill','center'] }, \
								sizeXEditText: EditText { text:'" + G3D.sizeX + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								sizeZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								sizeZScroll:Scrollbar { minvalue:100, maxvalue:1000, preferredSize:"+ G3D.scrollSize +", value: " + G3D.sizeZ + ", stepdelta:1, jumpdelta:50, alignment:['fill','center'] }, \
								sizeZEditText: EditText { text:'" + G3D.sizeZ + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
						}\
						Panel2: Panel { text: 'No. Divisions', orientation: 'column', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								divisionsXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								divisionsXScroll:Scrollbar { minvalue:2, maxvalue:50, preferredSize:"+ G3D.scrollSize +", value: " + G3D.divisionsX + ", stepdelta:1, jumpdelta:5, alignment:['fill','center'] }, \
								divisionsXEditText: EditText { text:'" + G3D.divisionsX + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								divisionsZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								divisionsZScroll:Scrollbar { minvalue:2, maxvalue:50, preferredSize:"+ G3D.scrollSize +", value: " + G3D.divisionsZ + ", stepdelta:1, jumpdelta:5, alignment:['fill','center'] }, \
								divisionsZEditText: EditText { text:'" + G3D.divisionsZ + "', characters:5, preferredSize: " + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
						}\
						Panel3: Panel { text: 'Placement', orientation: 'row', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								placementXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementXEditText: EditText { text:'" + G3D.placement[0] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								placementYText: StaticText { text:'Y ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementYEditText: EditText { text:'" + G3D.placement[1] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
							Gr3: Group {\
								alignment:['right','top'], spacing:5,\
								placementZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementZEditText: EditText { text:'" + G3D.placement[2] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
						}\
						" + ((parseFloat(app.version) >= 9.0) ? "Panel4: Panel { text: 'Progress', orientation: 'row', minimumSize:" + G3D.panelSize + ",progress: Progressbar { alignment:['center','top'], preferredSize:[180,15] }}" : "")
						+ "footer: Group { \
								alignment:['right','top'], \
								help: Button { text:'" + G3D.strHelp + "', preferredSize:[30,20], alignment:['left','center'] }, \
								underCamButton: Button { text:'" + G3D.undrCamButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
								mainButton: Button { text:'" + G3D.strButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
						}, \
					}";
					
				pal.grp = pal.add(res);
				
				var darkBrush = pal.graphics.newPen(pal.graphics.BrushType.SOLID_COLOR, [0,0,0], 1);
				pal.grp.Panel1.Gr1.sizeXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel1.Gr2.sizeZEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel2.Gr1.divisionsXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel2.Gr2.divisionsZEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr1.placementXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr2.placementYEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr3.placementZEditText.graphics.foregroundColor  = darkBrush;
				
				//pal.onFocus = alert("focus");
				
				pal.grp.footer.help.onClick = function () {alert(G3D.scriptTitle + "\n" + G3D.help, G3D.scriptName);}
				pal.grp.footer.underCamButton.onClick = function ()
				{
					G3D.posIndex = (G3D.posIndex + 1)%3; //change this to 4 if and when I add the fourth option
					G3D.placement = G3Dplacement(G3D.posIndex);
					pal.grp.Panel3.Gr1.placementXEditText.text = G3D.placement[0];
					pal.grp.Panel3.Gr2.placementYEditText.text = G3D.placement[1];
					pal.grp.Panel3.Gr3.placementZEditText.text = G3D.placement[2];
				}
				pal.grp.footer.mainButton.onClick = G3DmainFunction;
				
				//link scrollbar and text
				//SIZE X
				pal.grp.Panel1.Gr1.sizeXScroll.onChange = pal.grp.Panel1.Gr1.sizeXScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.sizeX = this.value;
					this.parent.sizeXEditText.text = G3D.sizeX;
				}
				pal.grp.Panel1.Gr1.sizeXEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.sizeX;
					this.parent.sizeXScroll.value = parseInt(this.text);
					G3D.sizeX = parseInt(this.text);
				}
		
				//SIZE Z
				pal.grp.Panel1.Gr2.sizeZScroll.onChange = pal.grp.Panel1.Gr2.sizeZScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.sizeZ = this.value;
					this.parent.sizeZEditText.text = G3D.sizeZ;
				}
				pal.grp.Panel1.Gr2.sizeZEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.sizeZ;
					this.parent.sizeZScroll.value = parseInt(this.text);
					G3D.sizeZ = parseInt(this.text);
				}
			
				//DIVISIONS X
				pal.grp.Panel2.Gr1.divisionsXScroll.onChange = pal.grp.Panel2.Gr1.divisionsXScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.divisionsX = this.value;
					this.parent.divisionsXEditText.text = G3D.divisionsX;
				}
				pal.grp.Panel2.Gr1.divisionsXEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.divisionsX;
					this.parent.divisionsXScroll.value = parseInt(this.text);
					G3D.divisionsX = parseInt(this.text);
				}
			
				//DIVISIONS Z
				pal.grp.Panel2.Gr2.divisionsZScroll.onChange = pal.grp.Panel2.Gr2.divisionsZScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.divisionsZ = this.value;
					this.parent.divisionsZEditText.text = G3D.divisionsZ;
				}
				pal.grp.Panel2.Gr2.divisionsZEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.divisionsZ;
					this.parent.divisionsZScroll.value = parseInt(this.text);
					G3D.divisionsZ = parseInt(this.text);
				}
			
				//progress bar
				if(parseFloat(app.version) >= 9.0) pal.grp.Panel4.progress.value = 0;
                
                  pal.layout.layout(true);
				pal.grp.minimumSize = pal.grp.size;
				pal.layout.resize();
				pal.onResizing = pal.onResize = function () {this.layout.resize();}
			
				
			} //if (pal != null)
		
			return(pal);
			
		} // function createUI
		

		function G3Dtrace(s) {
			$.writeln(s); // writes to the ExtendScript interface
			//writeLn("3DR: " + s); // writes in the AE info window
		}
	
		function G3DmainFunction() {
			//MAIN FUNCTION
			
			proj = app.project;
			activeItem = proj.activeItem;
			
			if (!activeItem || ! activeItem instanceof CompItem){
				alert(G3D.noActiveItem);
			} else {
					
				app.beginUndoGroup(undoStr);
				
				G3D.placement = [parseFloat(G3D.toolsPanel.grp.Panel3.Gr1.placementXEditText.text), parseFloat(G3D.toolsPanel.grp.Panel3.Gr2.placementYEditText.text), parseFloat(G3D.toolsPanel.grp.Panel3.Gr3.placementZEditText.text)];
				
				var compDims = [Math.floor(G3D.sizeX * G3D.divisionsX), Math.floor(G3D.sizeZ * G3D.divisionsZ)];
				
				//create a new composition in a folder in the same location as the activeComp
				G3D.folder = proj.items.addFolder(G3D.scriptName);
				G3D.comp = proj.items.addComp(G3D.scriptName + " - " + activeItem.name, compDims[0], compDims[1], 1, activeItem.duration, activeItem.frameRate);
				G3D.comp.parentFolder = G3D.folder;
				G3D.folder.parentFolder = activeItem.parentFolder;
				
				//create a null in the middle
				G3D.cNull = G3D.comp.layers.addNull(G3D.comp.duration);
				G3D.cNull.threeDLayer = true;
				G3D.cNull.transform.position.setValue([G3D.comp.width/2, G3D.comp.height/2, 0]);
				
				//create solid and set to wireframe
				G3D.indexLayer = G3D.comp.layers.addSolid([0,0,0], G3D.scriptName + " element", G3D.sizeX, G3D.sizeZ, 1, G3D.comp.duration);
				G3D.indexLayer.threeDLayer = true;
				G3D.indexLayer.quality = LayerQuality.WIREFRAME;
				G3D.indexLayer.transform.anchorPoint.setValue([0,0,0]);
				G3D.indexLayer.transform.position.setValue([0,0,0]);
				
				//loop - duplicate and place solid
				
				var tProgress = 0;
				var tProgressUnit = 1/(G3D.divisionsZ*G3D.divisionsX);
				
				for(var i = 0; i < G3D.divisionsZ; i++) 
				{
					for(var j = 0; j < G3D.divisionsX; j++)
					{
						if(parseFloat(app.version) >= 9.0) {
							tProgress++;
							G3D.toolsPanel.grp.Panel4.progress.value = tProgress*100*tProgressUnit;
							G3D.toolsPanel.update();
						}
						var tLayer = G3D.indexLayer.duplicate();
						tLayer.transform.position.setValue([G3D.sizeX*j, G3D.sizeZ*i, 0]);
						//tLayer.name = tLayer.name + " " + i + "/" + j;
						//trace("solid " + i + "/" + j);
						tLayer.parent = G3D.cNull;
					}
				}
				
				//delete the original
				G3D.indexLayer.remove();
				
				G3D.cNull.transform.orientation.setValue([90,0,0]);
				
				//put the comp as the top layer of activeItem
				G3D.gridLayer = activeItem.layers.add(G3D.comp,activeItem.duration);
				
				//name the layer
				G3D.gridLayer.name = G3D.scriptName;
				
				//set it to collapsed / 3D
				G3D.gridLayer.threeDLayer = true;
				G3D.gridLayer.collapseTransformation = true;
				
				//position it
				G3D.gridLayer.transform.position.setValue(G3D.placement);
				
				//place it behind bottommost 3D layer
				for(var i = activeItem.numLayers; i >= 1; i--) {
					if(activeItem.layer(i).threeDLayer && activeItem.layer(i) != G3D.gridLayer) {
						G3D.gridLayer.moveAfter(activeItem.layer(i));
						break;
					}
				}
			
				//move it to time 0
				G3D.gridLayer.startTime = activeItem.displayStartTime;
				
				//lock it
				G3D.gridLayer.guideLayer = true;
				G3D.gridLayer.locked = true;
				
				//set progress bar back to 0
				
				if(parseFloat(app.version) >= 9.0) G3D.toolsPanel.grp.Panel4.progress.value = 0;
				
				
				app.endUndoGroup();
				
			}
			
		} //function mainFunction()
	
	}//function do3DGrid
	
}